#include <bits/stdc++.h>

using namespace std;

const int MAXN = 200100;
const int MOD = 1e9 + 7;

int ha[MAXN];
int base[MAXN];

inline int add(int A, int B){
    if(A + B >= MOD)
        return A + B - MOD;
    return A + B;
}

inline int sub(int A, int B) {
    if(A - B < 0)
        return A - B + MOD;
    return A - B;
}

inline int mul(int A, int B){
    return (long long)A * B % MOD;
}

int get_hash(int a, int b) {
  return sub(ha[b], mul((a ? ha[a - 1] : 0), base[b - a + 1]));
}

int n;
int cmp(int a, int b) {
  int lo = 0, hi = n;
  while (lo < hi) {
    int mi = (lo + hi) / 2;
    if (get_hash(a, a + mi) == get_hash(b, b + mi)) lo = mi + 1;
    else                                            hi = mi;
  }
  return lo;
}

int main() {
  ios_base::sync_with_stdio(false);

  string s;
  int k;
  cin >> s >> k;
  n = s.size();

  if (k == 0) {
    cout << s << "\n";
    return 0;
  }

  if (k > 1) {
    sort(s.begin(), s.end());
    cout << s << "\n";
    return 0;
  }

  s = s + s;
  int x = 1;
  base[0] = 1; 
  for (auto c : s) {
    ha[x] = add(mul(ha[x - 1] , 31337 ), c);
    base[x] = mul(base[x - 1] , 31337);
    x++;
  }

  int sol = 1;
  for (int i = 1; i <= n; i++) {
    int a = cmp(sol, i);
    if (a < n && s[i - 1 + a] < s[sol - 1 + a]) sol = i;
  }

  cout << s.substr(sol - 1, n) << endl;

  return 0;
}
